/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.filed;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.NodeDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileDialogOpenPanelBean
extends PanelBean
implements DataBean {
    private static final String TRACE_MASKT = "FILEDOBT";
    private static final String TRACE_MASKF = "FILEDOBF";
    private static final String TRACE_MASKD = "FILEDOBD";
    public static final String KEY_MULTI_SELECT = "multiSelect";
    public static final String KEY_MUST_EXIST = "mustExist";
    public static final String KEY_FILENAME = "fileName";
    public static final String KEY_DIRPATH = "dirPath";
    public static final String KEY_DIRLIST = "dirList";
    public static final String KEY_FILELIST = "fileList";
    public static final String COMMAND_DIRECTORY = "directory";
    private String panelName = null;
    boolean multiSelect = false;
    boolean mustExist = false;
    List fileList = null;
    List dirList = null;
    private String selectedDirPath = new String();
    private boolean initialDirSel = false;
    private String m_sNameEdit;
    private ItemDescriptor[] m_idFileTable;
    private ColumnDescriptor[] m_cdFileTableStructure;
    private int[] m_iFileTableSelection;
    private String m_sDirectoryTree;
    private NodeDescriptor[] m_ndDirectoryTree;
    private NodeDescriptor[] m_ndDirectoryTreeSelection;
    private String m_sSelectedOutput;
    private boolean updatingTable = false;

    public void setPanelName(String s) {
        this.panelName = s;
    }

    public void setMultiSelect(boolean _multiSelect) {
        this.multiSelect = _multiSelect;
    }

    public void setMustExist(boolean _mustExist) {
        this.mustExist = _mustExist;
    }

    public void setFileList(List _fileList) {
        this.fileList = _fileList;
    }

    public void setDirList(List _dirList) {
        this.dirList = _dirList;
    }

    public String getNameEdit() {
        return this.m_sNameEdit;
    }

    public void setNameEdit(String s) throws IllegalUserDataException {
        if (this.m_sNameEdit != null && !this.m_sNameEdit.equals(s)) {
            this.clearFileTableSelection();
        }
        this.m_sNameEdit = s;
    }

    public ColumnDescriptor[] getFileTableRowStructure() {
        return this.m_cdFileTableStructure;
    }

    public int getFileTableRowStatus() {
        return 3;
    }

    public int getFileTableRowCount() {
        return this.m_idFileTable.length;
    }

    public ItemDescriptor[] getFileTableRowAt(int index) {
        ItemDescriptor[] rowAt = new ItemDescriptor[]{this.m_idFileTable[index]};
        return rowAt;
    }

    public void setFileTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idFileTable[index] = items[0];
    }

    public int[] getFileTableSelection() {
        return this.m_iFileTableSelection;
    }

    public void setFileTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iFileTableSelection = selected;
        this.updatingTable = true;
        if (selected == null || selected.length != 1) {
            this.setNameEdit("");
        } else {
            this.setNameEdit(this.m_idFileTable[selected[0]].getName());
        }
        this.userTaskManager.refreshElement("NameEdit");
        this.updatingTable = false;
        this.generateSelectedOutput();
        this.userTaskManager.refreshElement("SelectedOutput");
    }

    private void clearFileTableSelection() {
        if (!this.updatingTable) {
            this.m_iFileTableSelection = new int[0];
            this.userTaskManager.refreshElement("FileTable");
        }
    }

    private ArrayList getSelectedFiles() {
        ArrayList<String> selectedFileList = new ArrayList<String>();
        if (this.m_iFileTableSelection != null) {
            for (int i = 0; i < this.m_iFileTableSelection.length; ++i) {
                Trace.trace(TRACE_MASKD, "<> getSelectedFiles: item " + this.m_iFileTableSelection[i]);
                selectedFileList.add(this.m_idFileTable[this.m_iFileTableSelection[i]].getName());
            }
        }
        return selectedFileList;
    }

    public NodeDescriptor[] getDirectoryTreeChildren() {
        if (this.dirList == null) {
            return null;
        }
        String bottomDirPath = (String)this.dirList.get(0);
        if (this.m_sDirectoryTree == null || !this.m_sDirectoryTree.equals(bottomDirPath)) {
            this.m_ndDirectoryTree = new NodeDescriptor[1];
            String nodeName = null;
            String nodeTitle = null;
            if (this.m_sDirectoryTree == null) {
                nodeName = "/";
                nodeTitle = "/";
            } else {
                String cutParent = bottomDirPath.substring(this.m_sDirectoryTree.length());
                nodeName = this.m_sDirectoryTree + cutParent.substring(0, cutParent.indexOf("/")) + "/";
                nodeTitle = cutParent.substring(0, cutParent.indexOf("/"));
            }
            this.m_ndDirectoryTree[0] = new NodeDescriptor(nodeName, nodeTitle);
            this.m_ndDirectoryTree[0].setLeaf(bottomDirPath.equals(nodeName) && this.dirList.size() == 1);
            this.m_ndDirectoryTree[0].setExpandRequested(true);
        } else {
            if (this.dirList.size() == 1) {
                return null;
            }
            this.m_ndDirectoryTree = new NodeDescriptor[this.dirList.size() - 1];
            String nodeName = null;
            String nodeTitle = null;
            for (int i = 1; i < this.dirList.size(); ++i) {
                nodeName = (String)this.dirList.get(i);
                nodeTitle = nodeName.substring(nodeName.lastIndexOf("/") + 1);
                this.m_ndDirectoryTree[i - 1] = new NodeDescriptor(nodeName, nodeTitle);
                this.m_ndDirectoryTree[i - 1].setLeaf(true);
                this.m_ndDirectoryTree[i - 1].setExpandRequested(false);
            }
        }
        return this.m_ndDirectoryTree;
    }

    public void setDirectoryTreeTreeParent(String name) {
        this.m_sDirectoryTree = name;
    }

    public NodeDescriptor[] getDirectoryTreeSelection() {
        return this.m_ndDirectoryTreeSelection;
    }

    public void setDirectoryTreeSelection(NodeDescriptor[] selected) {
        this.m_ndDirectoryTreeSelection = selected;
        if (selected.length == 0) {
            this.selectedDirPath = new String();
            return;
        }
        this.selectedDirPath = selected[selected.length - 1].getName();
        if (!this.selectedDirPath.endsWith("/")) {
            this.selectedDirPath = this.selectedDirPath + "/";
        }
        Trace.trace(TRACE_MASKD, "<> setDirectoryTreeSelection:" + this.selectedDirPath);
        if (this.initialDirSel && this.selectedDirPath.equals((String)this.dirList.get(0))) {
            this.initialDirSel = false;
            return;
        }
        this.initialDirSel = false;
        PanelTaskletRequest request = new PanelTaskletRequest();
        request.setData("source", this.panelName);
        request.setData("command", COMMAND_DIRECTORY);
        request.setData(KEY_DIRPATH, this.selectedDirPath);
        Trace.trace(TRACE_MASKT, "posting TaskletRequest (directory selection)");
        this.postTaskletRequest(request);
    }

    public String getSelectedOutput() {
        return this.m_sSelectedOutput;
    }

    public void setSelectedOutput(String s) throws IllegalUserDataException {
        this.m_sSelectedOutput = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.m_idFileTable = new ItemDescriptor[0];
        this.m_cdFileTableStructure = new ColumnDescriptor[1];
        this.m_cdFileTableStructure[0] = new ColumnDescriptor(KEY_FILELIST, "", true);
        this.m_iFileTableSelection = new int[0];
        this.m_sDirectoryTree = "";
        this.m_ndDirectoryTree = new NodeDescriptor[0];
        this.m_ndDirectoryTreeSelection = new NodeDescriptor[0];
        this.m_sSelectedOutput = "";
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction(" + event + ")");
        if (event.getActionCommand().equals("CANCEL") || event.getActionCommand().endsWith("CancelButton")) {
            this.dispose();
        } else {
            this.setNameEdit(this.userTaskManager.getValue("NameEdit"));
            if ((event.getActionCommand().equals("OKButton") || event.getActionCommand().equals("OpenButton")) && this.getNameEdit().equals("") && this.getSelectedFiles().size() == 0) {
                Trace.trace(TRACE_MASKT, "<- panelAction()");
                return;
            }
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("source", this.panelName);
            request.setData("event", event);
            request.setData("command", event.getActionCommand());
            request.setData(KEY_MULTI_SELECT, new Boolean(this.multiSelect));
            request.setData(KEY_MUST_EXIST, new Boolean(this.mustExist));
            request.setData(KEY_FILENAME, this.getNameEdit());
            if (this.selectedDirPath.equals("")) {
                this.selectedDirPath = (String)this.dirList.get(0);
            }
            request.setData(KEY_DIRPATH, this.selectedDirPath);
            request.setData(KEY_FILELIST, this.getSelectedFiles());
            Trace.trace(TRACE_MASKT, "posting TaskletRequest (user action):filename:" + this.getNameEdit() + ":dirpath:" + this.selectedDirPath + ":num files selected:" + this.getSelectedFiles().size());
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKD, "<> prepare:filename:" + this.getNameEdit() + ":dirpath:" + (String)this.dirList.get(0));
        if (this.multiSelect) {
            this.userTaskManager.setAttribute("FileTable", 16, "MULTIPLE");
        } else {
            this.userTaskManager.setAttribute("FileTable", 16, "SINGLE");
        }
        this.buildFileTable();
        this.selectedDirPath = new String();
        this.generateSelectedOutput();
    }

    public void update(Object updateData) {
        this.setNameEdit((String)((Map)updateData).get(KEY_FILENAME));
        this.setDirList((List)((Map)updateData).get(KEY_DIRLIST));
        this.setFileList((List)((Map)updateData).get(KEY_FILELIST));
        Trace.trace(TRACE_MASKD, "--> update:filename:" + this.getNameEdit() + ":dirpath:" + (String)this.dirList.get(0));
        this.buildFileTable();
        this.selectedDirPath = new String();
        this.generateSelectedOutput();
        Trace.trace(TRACE_MASKD, "refreshing...");
        this.userTaskManager.refreshAllElements();
        Trace.trace(TRACE_MASKD, "<-- update");
    }

    private void buildFileTable() {
        if (this.fileList == null) {
            return;
        }
        this.m_idFileTable = new ItemDescriptor[this.fileList.size()];
        Iterator iter = this.fileList.iterator();
        String fileName = null;
        for (int i = 0; i < this.fileList.size(); ++i) {
            fileName = (String)iter.next();
            this.m_idFileTable[i] = new ItemDescriptor(fileName, fileName);
        }
    }

    private void generateSelectedOutput() {
        Object[] subst = new Integer[]{this.m_iFileTableSelection == null ? new Integer(0) : new Integer(this.m_iFileTableSelection.length), new Integer(this.m_idFileTable.length)};
        this.setSelectedOutput(new LocalizableText(BaseTextBundle.getBundleName(), "filed.open.selected.text", subst).toString());
    }
}

